# utils.py
from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton
from db import get_menu_buttons

def create_menu_keyboard(lang):
    """
    Создает inline-клавиатуру с кнопками меню для указанного языка.
    Ряды: [1,2], [3], [4,5], [6,7], [8]
    """
    buttons = get_menu_buttons(lang)
    keyboard = InlineKeyboardMarkup(inline_keyboard=[])
    
    # button1 и button2
    row1 = []
    if buttons.get('button1'):
        row1.append(InlineKeyboardButton(text=buttons['button1'], callback_data=f"btn1_{lang}"))
    if buttons.get('button2'):
        row1.append(InlineKeyboardButton(text=buttons['button2'], callback_data=f"btn2_{lang}"))
    if row1:
        keyboard.inline_keyboard.append(row1)
    
    # button3
    if buttons.get('button3'):
        row3 = [InlineKeyboardButton(text=buttons['button3'], callback_data=f"btn3_{lang}")]
        keyboard.inline_keyboard.append(row3)
    
    # button4 и button5
    row45 = []
    if buttons.get('button4'):
        row45.append(InlineKeyboardButton(text=buttons['button4'], callback_data=f"btn4_{lang}"))
    if buttons.get('button5'):
        row45.append(InlineKeyboardButton(text=buttons['button5'], callback_data=f"btn5_{lang}"))
    if row45:
        keyboard.inline_keyboard.append(row45)
    
    # button6 и button7
    row67 = []
    if buttons.get('button6'):
        row67.append(InlineKeyboardButton(text=buttons['button6'], callback_data=f"btn6_{lang}"))
    if buttons.get('button7'):
        row67.append(InlineKeyboardButton(text=buttons['button7'], callback_data=f"btn7_{lang}"))
    if row67:
        keyboard.inline_keyboard.append(row67)
    
    # button8
    if buttons.get('button8'):
        row8 = [InlineKeyboardButton(text=buttons['button8'], callback_data=f"btn8_{lang}")]
        keyboard.inline_keyboard.append(row8)
    
    return keyboard