<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$success = $_SESSION['success'] ?? null;
$error = $_SESSION['error'] ?? null;
unset($_SESSION['success'], $_SESSION['error']);

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['language'])) {
    $language = trim($_POST['language']);
    if (!empty($language)) {
        try {
            $pdo = new PDO('sqlite:bot_menu.db');
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Check if all required columns exist, add missing ones
            $stmt = $pdo->query("PRAGMA table_info(language)");
            $columns = $stmt->fetchAll(PDO::FETCH_COLUMN, 1);
            
            $required_columns = ['text13', 'text14', 'text15', 'text16', 'text17', 'text18', 'text19', 'text20', 'text21', 'text22', 'text23', 'text24', 'text25', 'text26', 'text27', 'text28', 'text29', 'text30', 'text31', 'text32', 'button17', 'button18', 'button19', 'button20'];
            foreach ($required_columns as $col) {
                if (!in_array($col, $columns)) {
                    $pdo->exec("ALTER TABLE language ADD COLUMN $col TEXT");
                }
            }
            
            $stmt = $pdo->prepare('
                REPLACE INTO language (name, text1, text2, text3, text4, text5, text6, text7, text8, text9, text10, text11, text12, text13, text14, text15, text16, text17, text18, text19, text20, text21, text22, text23, text24, text25, text26, text27, text28, text29, text30, text31, text32, button1, button2, button3, button4, button5, button6, button7, button8, button9, button10, button11, button12, button13, button14, button15, button16, button17, button18, button19, button20) 
                VALUES (:language, :text1, :text2, :text3, :text4, :text5, :text6, :text7, :text8, :text9, :text10, :text11, :text12, :text13, :text14, :text15, :text16, :text17, :text18, :text19, :text20, :text21, :text22, :text23, :text24, :text25, :text26, :text27, :text28, :text29, :text30, :text31, :text32, :button1, :button2, :button3, :button4, :button5, :button6, :button7, :button8, :button9, :button10, :button11, :button12, :button13, :button14, :button15, :button16, :button17, :button18, :button19, :button20)
            ');
            $stmt->execute([
                'language' => $language,
                'text1' => trim($_POST['text1'] ?? ''),
                'text2' => trim($_POST['text2'] ?? ''),
                'text3' => trim($_POST['text3'] ?? ''),
                'text4' => trim($_POST['text4'] ?? ''),
                'text5' => trim($_POST['text5'] ?? ''),
                'text6' => trim($_POST['text6'] ?? ''),
                'text7' => trim($_POST['text7'] ?? ''),
                'text8' => trim($_POST['text8'] ?? ''),
                'text9' => trim($_POST['text9'] ?? ''),
                'text10' => trim($_POST['text10'] ?? ''),
                'text11' => trim($_POST['text11'] ?? ''),
                'text12' => trim($_POST['text12'] ?? ''),
                'text13' => trim($_POST['text13'] ?? ''),
                'text14' => trim($_POST['text14'] ?? ''),
                'text15' => trim($_POST['text15'] ?? ''),
                'text16' => trim($_POST['text16'] ?? ''),
                'text17' => trim($_POST['text17'] ?? ''),
                'text18' => trim($_POST['text18'] ?? ''),
                'text19' => trim($_POST['text19'] ?? ''),
                'text20' => trim($_POST['text20'] ?? ''),
                'text21' => trim($_POST['text21'] ?? ''),
                'text22' => trim($_POST['text22'] ?? ''),
                'text23' => trim($_POST['text23'] ?? ''),
                'text24' => trim($_POST['text24'] ?? ''),
                'text25' => trim($_POST['text25'] ?? ''),
                'text26' => trim($_POST['text26'] ?? ''),
                'text27' => trim($_POST['text27'] ?? ''),
                'text28' => trim($_POST['text28'] ?? ''),
                'text29' => trim($_POST['text29'] ?? ''),
                'text30' => trim($_POST['text30'] ?? ''),
                'text31' => trim($_POST['text31'] ?? ''),
                'text32' => trim($_POST['text32'] ?? ''),
                'button1' => trim($_POST['button1'] ?? ''),
                'button2' => trim($_POST['button2'] ?? ''),
                'button3' => trim($_POST['button3'] ?? ''),
                'button4' => trim($_POST['button4'] ?? ''),
                'button5' => trim($_POST['button5'] ?? ''),
                'button6' => trim($_POST['button6'] ?? ''),
                'button7' => trim($_POST['button7'] ?? ''),
                'button8' => trim($_POST['button8'] ?? ''),
                'button9' => trim($_POST['button9'] ?? ''),
                'button10' => trim($_POST['button10'] ?? ''),
                'button11' => trim($_POST['button11'] ?? ''),
                'button12' => trim($_POST['button12'] ?? ''),
                'button13' => trim($_POST['button13'] ?? ''),
                'button14' => trim($_POST['button14'] ?? ''),
                'button15' => trim($_POST['button15'] ?? ''),
                'button16' => trim($_POST['button16'] ?? ''),
                'button17' => trim($_POST['button17'] ?? ''),
                'button18' => trim($_POST['button18'] ?? ''),
                'button19' => trim($_POST['button19'] ?? ''),
                'button20' => trim($_POST['button20'] ?? '')
            ]);
            $_SESSION['success'] = 'Переводы сохранены успешно!';
            header('Location: texts.php');
            exit();
        } catch (PDOException $e) {
            $error = 'Ошибка сохранения: ' . $e->getMessage();
        }
    } else {
        $error = 'Язык не выбран!';
    }
}

// Fetch languages with translations
$languages = [];
try {
    $pdo = new PDO('sqlite:bot_menu.db');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Fetch languages with button translations
    $stmt = $pdo->query('SELECT * FROM language ORDER BY name ASC');
    $languages = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $error = 'Ошибка загрузки данных: ' . $e->getMessage();
}

// Button labels
$button_labels = [
    'button1' => 'Каталог',
    'button2' => 'информация',
    'button3' => 'мои покупки',
    'button4' => 'доставка',
    'button5' => 'сотрудничество',
    'button6' => 'оператор',
    'button7' => 'реферальная система',
    'button8' => 'Пополнить баланс',
    'button9' => 'назад',
    'button10' => 'Поиск',
    'button11' => 'Доставка',
    'button12' => 'Самовывоз',
    'button13' => 'CryptoBot',
    'button14' => 'Банковская карта',
    'button15' => 'проверить оплату',
    'button16' => 'Со своего баланса',
    'button17' => 'Оплатить',
    'button18' => 'Согласен',
    'button19' => 'Настройки',
    'button20' => 'Сменить язык'
];

// Text labels
$text_labels = [
    'text1' => 'приветствие',
    'text2' => '📌 Введите название города:',
    'text3' => 'город не найден',
    'text4' => 'Город:',
    'text5' => 'Список товаров',
    'text6' => 'Выберите тег',
    'text7' => 'Выберите тип доставки',
    'text8' => 'Выберите Вы уверены что хотите приоебрести',
    'text9' => 'После подтверждения оплата не возвращается',
    'text10' => 'Выберите способ оплаты',
    'text11' => 'Товар',
    'text12' => 'Город',
    'text13' => 'Оплатите 1$',
    'text14' => 'Проведите оплату по кнопке ниже',
    'text15' => 'Оплата прошла успешно',
    'text16' => 'Оплата не прошла',
    'text17' => 'Успешная оплата при доставке',
    'text18' => 'Текст при оплате картой',
    'text19' => 'Сообщение для банковской оплаты',
    'text20' => '♻️Ваша реферальная ссылка:',
    'text21' => 'по вашей ссылке перешли',
    'text22' => 'Текст кнопки Информация',
    'text23' => 'Успешная оплата Со своего баланса',
    'text24' => 'Вопрос при пополнении баланса',
    'text25' => '📦 История покупок не найдена',
    'text26' => 'Вывод текста пополнение банк картой',
    'text27' => 'Текст пункта доставка',
    'text28' => 'Текст Раздела мой профиль',
    'text29' => 'Текст Раздела Оператор',
    'text30' => 'Раздел мои заказы Ваши заказы:',
    'text31' => 'Раздел есть Работа',
    'text32' => 'Раздел работа нету работы'
];
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Тексты и кнопки - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <?php include 'header.php'; ?>
    
    <!-- Main Content -->
    <main class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-lg p-8">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">Тексты и кнопки</h2>
            
            <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <div class="space-y-4">
                <?php if (empty($languages)): ?>
                    <p class="text-gray-500">Нет доступных языков. <a href="languages.php" class="text-blue-600 hover:underline">Добавить языки</a></p>
                <?php else: ?>
                    <?php foreach ($languages as $lang): ?>
                        <?php 
                        $lang_name = $lang['name'];
                        $trans = $lang; // Direct from language row
                        ?>
                        <details class="border border-gray-200 rounded-lg">
                            <summary class="cursor-pointer bg-gray-50 px-4 py-3 text-lg font-medium text-gray-900 rounded-t-lg">
                                <?php echo htmlspecialchars($lang_name); ?>
                            </summary>
                            <div class="p-6 bg-gray-50">
                                <form method="POST" class="space-y-6">
                                    <input type="hidden" name="language" value="<?php echo htmlspecialchars($lang_name); ?>">
                                    
                                    <!-- Buttons Section -->
                                    <div class="border-t pt-4">
                                        <h4 class="text-lg font-medium text-gray-900 mb-4">Переводы кнопок</h4>
                                        <?php foreach ($button_labels as $field => $label): ?>
                                            <div>
                                                <label for="<?php echo $field; ?>" class="block text-sm font-medium text-gray-700">
                                                    Перевод кнопки <?php echo htmlspecialchars($label); ?> <span class="text-gray-500 font-normal">(<?php echo $field; ?>)</span>
                                                </label>
                                                <input type="text" 
                                                       id="<?php echo $field; ?>" 
                                                       name="<?php echo $field; ?>" 
                                                       value="<?php echo htmlspecialchars($trans[$field] ?? ''); ?>" 
                                                       class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500">
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                    
                                    <!-- Texts Section -->
                                    <div class="border-t pt-4">
                                        <h4 class="text-lg font-medium text-gray-900 mb-4">Тексты</h4>
                                        <?php foreach ($text_labels as $field => $label): ?>
                                            <div>
                                                <label for="<?php echo $field; ?>" class="block text-sm font-medium text-gray-700">
                                                    Введите текст : <?php echo htmlspecialchars($label); ?> <span class="text-gray-500 font-normal">(<?php echo $field; ?>)</span>
                                                </label>
                                                <textarea 
                                                        id="<?php echo $field; ?>" 
                                                        name="<?php echo $field; ?>" 
                                                        rows="4"
                                                        class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"><?php echo htmlspecialchars($trans[$field] ?? ''); ?></textarea>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                    
                                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg font-medium transition duration-200">
                                        Сохранить переводы для <?php echo htmlspecialchars($lang_name); ?>
                                    </button>
                                </form>
                            </div>
                        </details>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </main>
</body>
</html>