<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$success = $_SESSION['success'] ?? null;
$error = $_SESSION['error'] ?? null;
unset($_SESSION['success'], $_SESSION['error']);

// Read BOT_TOKEN from config.py
$bot_token = '';
if (file_exists('config.py')) {
    $config_content = file_get_contents('config.py');
    if (preg_match('/BOT_TOKEN\s*=\s*["\']([^"\']+)["\']/', $config_content, $matches)) {
        $bot_token = $matches[1];
    }
}

if (empty($bot_token)) {
    $error = 'Не удалось прочитать токен бота из config.py';
}

// Handle form submission
$sent_count = 0;
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['message']) && !empty($bot_token)) {
    $message = trim($_POST['message']);
    if (!empty($message)) {
        try {
            $pdo = new PDO('sqlite:data.db');
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $stmt = $pdo->query('SELECT user_id FROM users');
            $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($users as $user) {
                $chat_id = $user['user_id']; // Assuming user_id is Telegram chat ID
                $url = "https://api.telegram.org/bot{$bot_token}/sendMessage";
                $data = [
                    'chat_id' => $chat_id,
                    'text' => $message,
                    'parse_mode' => 'HTML' // Optional, adjust as needed
                ];
                
                $options = [
                    'http' => [
                        'header' => "Content-type: application/x-www-form-urlencoded\r\n",
                        'method' => 'POST',
                        'content' => http_build_query($data)
                    ]
                ];
                $context = stream_context_create($options);
                $result = file_get_contents($url, false, $context);
                
                if ($result !== false) {
                    $response = json_decode($result, true);
                    if (isset($response['ok']) && $response['ok']) {
                        $sent_count++;
                    }
                }
            }
            
            if ($sent_count > 0) {
                $_SESSION['success'] = "Рассылка отправлена успешно! Отправлено сообщений: {$sent_count}";
            } else {
                $_SESSION['error'] = 'Не удалось отправить ни одного сообщения.';
            }
            header('Location: newsletter.php');
            exit();
        } catch (PDOException $e) {
            $error = 'Ошибка загрузки пользователей: ' . $e->getMessage();
        } catch (Exception $e) {
            $error = 'Ошибка отправки: ' . $e->getMessage();
        }
    } else {
        $error = 'Введите текст сообщения!';
    }
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Рассылка - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <?php include 'header.php'; ?>
    
    <!-- Main Content -->
    <main class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-lg p-8">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">Текстовая рассылка</h2>
            
            <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" class="space-y-4">
                <div>
                    <label for="message" class="block text-sm font-medium text-gray-700">Текст сообщения</label>
                    <textarea id="message" name="message" rows="6" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" placeholder="Введите текст для рассылки..."><?php echo htmlspecialchars($_POST['message'] ?? ''); ?></textarea>
                </div>
                <button type="submit" class="bg-red-600 hover:bg-red-700 text-white px-6 py-2 rounded-lg font-medium transition duration-200">
                    Отправить рассылку
                </button>
            </form>
        </div>
    </main>
</body>
</html>