<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$success = $_SESSION['success'] ?? null;
$error = $_SESSION['error'] ?? null;
unset($_SESSION['success'], $_SESSION['error']);

// Handle delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['product_id'])) {
    $product_id = (int)$_POST['product_id'];
    try {
        $pdo = new PDO('sqlite:data.db');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Delete image if exists
        $stmt = $pdo->prepare('SELECT product_image FROM products WHERE product_id = :id');
        $stmt->execute(['id' => $product_id]);
        $product = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($product && $product['product_image'] && file_exists($product['product_image'])) {
            unlink($product['product_image']);
        }
        
        $delete_stmt = $pdo->prepare('DELETE FROM products WHERE product_id = :id');
        $delete_stmt->execute(['id' => $product_id]);
        $_SESSION['success'] = 'Товар успешно удален!';
        header('Location: my_products.php');
        exit();
    } catch (PDOException $e) {
        $_SESSION['error'] = 'Ошибка удаления: ' . $e->getMessage();
        header('Location: my_products.php');
        exit();
    }
}

// Fetch products with city names
$products = [];
try {
    $pdo = new PDO('sqlite:data.db');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Get all cities for mapping
    $city_stmt = $pdo->query('SELECT city_id, city_name FROM city');
    $city_map = [];
    while ($city = $city_stmt->fetch(PDO::FETCH_ASSOC)) {
        $city_map[$city['city_id']] = $city['city_name'];
    }
    
    // Fetch products
    $stmt = $pdo->query('SELECT * FROM products ORDER BY product_id DESC');
    while ($product = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Parse cities
        $city_ids = explode(',', $product['product_city']);
        $city_names = [];
        foreach ($city_ids as $id) {
            $id = trim($id);
            if (isset($city_map[$id])) {
                $city_names[] = $city_map[$id];
            }
        }
        $product['city_names'] = implode(', ', $city_names);
        
        // Combine tags
        $tags = array_filter([
            $product['product_tags'],
            $product['product_tags2'],
            $product['product_tags3'],
            $product['product_tags4']
        ]);
        $product['tags_list'] = implode(' | ', $tags);
        
        $products[] = $product;
    }
} catch (PDOException $e) {
    $error = 'Ошибка загрузки товаров: ' . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Мои товары - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <?php include 'header.php'; ?>
    
    <!-- Main Content -->
    <main class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-lg p-8">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">Мои товары</h2>
            
            <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Название</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Города</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Изображение</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Описание</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Теги</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php if (empty($products)): ?>
                            <tr>
                                <td colspan="7" class="px-6 py-4 text-center text-gray-500">Нет товаров</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($products as $product): ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($product['product_id']); ?></td>
                                    <td class="px-6 py-4 text-sm text-gray-900"><?php echo htmlspecialchars($product['product_name']); ?></td>
                                    <td class="px-6 py-4 text-sm text-gray-900"><?php echo htmlspecialchars($product['city_names'] ?: 'Не указаны'); ?></td>
                                    <td class="px-6 py-4">
                                        <?php if ($product['product_image']): ?>
                                            <img src="<?php echo htmlspecialchars($product['product_image']); ?>" alt="Изображение" class="h-16 w-16 object-cover rounded">
                                        <?php else: ?>
                                            <span class="text-gray-500">Нет изображения</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900 max-w-xs truncate" title="<?php echo htmlspecialchars($product['product_description']); ?>">
                                        <?php echo htmlspecialchars($product['product_description'] ?: 'Не указано'); ?>
                                    </td>
                                    <td class="px-6 py-4 text-sm text-gray-900">
                                        <?php echo htmlspecialchars($product['tags_list'] ?: 'Не указаны'); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                        <a href="edit_product.php?edit=<?php echo $product['product_id']; ?>" class="text-blue-600 hover:text-blue-900">
                                            Редактировать
                                        </a>
                                        <form method="POST" class="inline" onsubmit="return confirm('Удалить товар "<?php echo htmlspecialchars($product['product_name']); ?>"?');">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="product_id" value="<?php echo $product['product_id']; ?>">
                                            <button type="submit" class="text-red-600 hover:text-red-900">
                                                Удалить
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            
            <div class="mt-6">
                <a href="create_product.php" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg font-medium transition duration-200">
                    Создать новый товар
                </a>
            </div>
        </div>
    </main>
</body>
</html>