<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

$edit_id = isset($_GET['edit']) ? (int)$_GET['edit'] : null;
$edit_language = null;

// Handle messages from session
$success = $_SESSION['success'] ?? null;
$error = $_SESSION['error'] ?? null;
unset($_SESSION['success'], $_SESSION['error']);

// Handle delete
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['name'])) {
    $name = $_POST['name'];
    try {
        $pdo = new PDO('sqlite:bot_menu.db');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $pdo->prepare('DELETE FROM language WHERE name = :name');
        $stmt->execute(['name' => $name]);
        $_SESSION['success'] = 'Язык успешно удален!';
        header('Location: languages.php');
        exit();
    } catch (PDOException $e) {
        $_SESSION['error'] = 'Ошибка удаления: ' . $e->getMessage();
        header('Location: languages.php');
        exit();
    }
}

// Handle edit/update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'update' && isset($_POST['name'])) {
    $name = trim($_POST['name']);
    if (!empty($name)) {
        try {
            $pdo = new PDO('sqlite:bot_menu.db');
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $stmt = $pdo->prepare('UPDATE language SET name = :name WHERE name = :old_name');
            $stmt->execute(['name' => $name, 'old_name' => $_POST['old_name']]);
            $_SESSION['success'] = 'Язык успешно обновлен!';
            header('Location: languages.php');
            exit();
        } catch (PDOException $e) {
            $error = 'Ошибка обновления: ' . $e->getMessage();
            $edit_id = $_POST['old_name']; // Stay in edit mode
        }
    } else {
        $error = 'Введите название языка!';
        $edit_id = $_POST['old_name']; // Stay in edit mode
    }
}

// Handle add
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add' && isset($_POST['name'])) {
    $name = trim($_POST['name']);
    if (!empty($name)) {
        try {
            $pdo = new PDO('sqlite:bot_menu.db');
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $stmt = $pdo->prepare('INSERT INTO language (name) VALUES (:name)');
            $stmt->execute(['name' => $name]);
            $_SESSION['success'] = 'Язык успешно добавлен!';
            header('Location: languages.php');
            exit();
        } catch (PDOException $e) {
            $error = 'Ошибка добавления: ' . $e->getMessage();
        }
    } else {
        $error = 'Введите название языка!';
    }
}

// Fetch existing languages
try {
    $pdo = new PDO('sqlite:bot_menu.db');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $stmt = $pdo->query('SELECT * FROM language ORDER BY name ASC');
    $languages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($edit_id) {
        $edit_stmt = $pdo->prepare('SELECT * FROM language WHERE name = :name');
        $edit_stmt->execute(['name' => $edit_id]);
        $edit_language = $edit_stmt->fetch(PDO::FETCH_ASSOC);
        if (!$edit_language) {
            $edit_id = null; // Invalid ID
        }
    }
} catch (PDOException $e) {
    $languages = [];
    $error = 'Ошибка загрузки языков: ' . $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Языки - Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <?php include 'header.php'; ?>
    
    <!-- Main Content -->
    <main class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-lg p-8">
            <h2 class="text-2xl font-bold text-gray-900 mb-6">Языки</h2>
            
            <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <!-- Edit Form -->
            <?php if ($edit_id && $edit_language): ?>
                <div class="mb-8 p-6 bg-yellow-50 rounded-lg border border-yellow-200">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Редактировать язык</h3>
                    <form method="POST" class="space-y-4">
                        <input type="hidden" name="action" value="update">
                        <input type="hidden" name="old_name" value="<?php echo htmlspecialchars($edit_language['name']); ?>">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700">Название языка</label>
                            <input type="text" id="name" name="name" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" value="<?php echo htmlspecialchars($edit_language['name']); ?>">
                        </div>
                        <div class="flex space-x-3">
                            <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg font-medium transition duration-200">
                                Сохранить изменения
                            </button>
                            <a href="languages.php" class="bg-gray-500 hover:bg-gray-600 text-white px-6 py-2 rounded-lg font-medium transition duration-200 text-center">
                                Отмена
                            </a>
                        </div>
                    </form>
                </div>
            <?php endif; ?>
            
            <!-- Add Language Form -->
            <?php if (!$edit_id): ?>
                <div class="mb-8 p-6 bg-gray-50 rounded-lg">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Создать язык</h3>
                    <form method="POST" class="space-y-4">
                        <input type="hidden" name="action" value="add">
                        <div>
                            <label for="name" class="block text-sm font-medium text-gray-700">Введите язык</label>
                            <input type="text" id="name" name="name" required class="mt-1 block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500" value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>">
                        </div>
                        <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg font-medium transition duration-200">
                            Сохранить
                        </button>
                    </form>
                </div>
            <?php endif; ?>
            
            <!-- Existing Languages Table -->
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Название языка</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Действия</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php if (empty($languages)): ?>
                            <tr>
                                <td colspan="2" class="px-6 py-4 text-center text-gray-500">Нет языков</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($languages as $lang): ?>
                                <tr class="hover:bg-gray-50">
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo htmlspecialchars($lang['name']); ?></td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium space-x-2">
                                        <a href="?edit=<?php echo urlencode($lang['name']); ?>" class="text-blue-600 hover:text-blue-900">
                                            Редактировать
                                        </a>
                                        <form method="POST" class="inline" onsubmit="return confirm('Удалить язык "<?php echo htmlspecialchars($lang['name']); ?>"?');">
                                            <input type="hidden" name="action" value="delete">
                                            <input type="hidden" name="name" value="<?php echo htmlspecialchars($lang['name']); ?>">
                                            <button type="submit" class="text-red-600 hover:text-red-900">
                                                Удалить
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>
</body>
</html>