import logging
import sqlite3
from aiogram import Router, F
from aiogram.types import CallbackQuery, Message, InlineKeyboardMarkup, InlineKeyboardButton
from db import get_user_language, get_language_text, get_button_text

logger = logging.getLogger(__name__)

router = Router(name="operator")

# Callback данные
BACK_CB = "menu:button9"

def get_button9_text(lang: str) -> str:
    """Получает текст кнопки назад"""
    label = "⬅️ Назад"
    try:
        from db import MENU_DB
        conn = sqlite3.connect(MENU_DB)
        cur = conn.cursor()
        cur.execute("SELECT button9 FROM language WHERE name = ?", (lang,))
        row = cur.fetchone()
        conn.close()
        if row and row[0] and str(row[0]).strip():
            label = str(row[0]).strip()
    except Exception as e:
        logger.error(f"get_button9_text error for lang={lang}: {e}")
    return label

def build_back_keyboard(lang: str) -> InlineKeyboardMarkup:
    """Создает клавиатуру с кнопкой назад"""
    return InlineKeyboardMarkup(
        inline_keyboard=[[InlineKeyboardButton(text=get_button9_text(lang), callback_data=BACK_CB)]]
    )

@router.callback_query(F.data == "menu:button6")
async def open_operator_info(cb: CallbackQuery):
    """
    Открывает информацию об операторе (button6)
    """
    user_id = cb.from_user.id
    lang = get_user_language(user_id)
    
    # Получаем текст из text29
    text29 = get_language_text(lang, "text29") or "Информация об операторе"
    
    try:
        await cb.message.delete()
    except Exception:
        pass
    
    # Отправляем текст об операторе с кнопкой назад
    await cb.message.answer(text29, reply_markup=build_back_keyboard(lang))
    await cb.answer()