import logging
from aiogram import Router, F
from aiogram.types import CallbackQuery, InlineKeyboardMarkup, InlineKeyboardButton
from db import get_user_language, get_language_text, get_button_text

logger = logging.getLogger(__name__)

router = Router(name="info")

def build_back_keyboard(lang: str) -> InlineKeyboardMarkup:
    """
    Создает клавиатуру с кнопкой button9 (назад)
    """
    button9_text = get_button_text(lang, "button9", "⬅️ Назад")
    
    keyboard = InlineKeyboardMarkup(
        inline_keyboard=[
            [InlineKeyboardButton(text=button9_text, callback_data="menu:button9")]
        ]
    )
    
    return keyboard

@router.callback_query(F.data == "menu:button2")
async def show_info(cb: CallbackQuery):
    """
    Показывает информацию при нажатии на button2
    """
    user_id = cb.from_user.id
    lang = get_user_language(user_id)
    
    print(f"=== INFO ===")
    print(f"User: {user_id}")
    
    # Получаем текст text22 из базы данных
    text22 = get_language_text(lang, "text22") or "Информация"
    
    # Создаем клавиатуру с кнопкой назад
    keyboard = build_back_keyboard(lang)
    
    # Удаляем предыдущее сообщение
    try:
        await cb.message.delete()
    except Exception:
        pass
    
    # Отправляем сообщение с информацией
    await cb.message.answer(text22, reply_markup=keyboard)
    
    await cb.answer()