<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header('Location: login.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Админ-панель</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <?php include 'header.php'; ?>
    <!-- Main Content -->
    <main class="max-w-7xl mx-auto py-12 px-4 sm:px-6 lg:px-8">
        <div class="bg-white rounded-2xl shadow-lg p-8 text-center">
            <h2 class="text-2xl font-bold text-gray-900 mb-4">Добро пожаловать!</h2>
            <p class="text-gray-600 mb-8">Содержимое будет добавлено позже. Это базовая панель управления.</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mt-8">
                <!-- Placeholder cards for future features -->
                <div class="bg-blue-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-blue-900 mb-2">Статистика</h3>
                    <p class="text-blue-700">Здесь будет график данных</p>
                </div>
                <div class="bg-green-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-green-900 mb-2">Управление</h3>
                    <p class="text-green-700">Инструменты для админа</p>
                </div>
                <div class="bg-purple-50 rounded-lg p-6">
                    <h3 class="text-lg font-medium text-purple-900 mb-2">Настройки</h3>
                    <p class="text-purple-700">Персонализация панели</p>
                </div>
            </div>
        </div>
    </main>
</body>
</html>